/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.craftingtweaks;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.container.slot.grid.SlotGridCrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class IntegrationCraftingTweaks {
    private static final String ID = "craftingtweaks";

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)ID);
    }

    public static void register() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ContainerClass", ContainerGrid.class.getName());
        tag.func_74778_a("ValidContainerPredicate", ValidContainerPredicate.class.getName());
        tag.func_74778_a("GetGridStartFunction", GetGridStartFunction.class.getName());
        tag.func_74778_a("AlignToGrid", "left");
        FMLInterModComms.sendMessage((String)ID, (String)"RegisterProviderV3", (NBTTagCompound)tag);
    }

    public static class GetGridStartFunction
    implements Function<ContainerGrid, Integer> {
        public Integer apply(ContainerGrid containerGrid) {
            if (containerGrid == null) {
                return 0;
            }
            for (int i = 0; i < containerGrid.field_75151_b.size(); ++i) {
                if (!(containerGrid.field_75151_b.get(i) instanceof SlotGridCrafting)) continue;
                return i;
            }
            return 0;
        }
    }

    public static class ValidContainerPredicate
    implements Predicate<ContainerGrid> {
        public boolean apply(ContainerGrid containerGrid) {
            return containerGrid.getGrid().getGridType() == GridType.CRAFTING;
        }
    }
}

